/*
** FCD treating interfaces
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 1999, 8/26 coding started for compress FCD treating
** 2000, 1/17 modified for multi data track FCD
*/

#include <stdio.h> /* FILE */
#include "fcd_basic.h"

#ifndef FCD_H
#define FCD_H

#ifdef  __cplusplus
extern "C" {
#endif

#define FCD_TYPE_ISO      0x00000001
#define FCD_TYPE_RAW      0x00000002
#define FCD_TYPE_DA       0x00000004
#define FCD_TYPE_UNKNOWN  0x00000000

#define FCD_COMPRESS_NO   0
#define FCD_COMPRESS_STD  1
#define FCD_COMPRESS_HI   2
#define FCD_COMP_UNKNOWN -1

typedef struct {
    int index;
    
    int type;
    LBN start;
    LBN num_of_block;
    LBN post_gap;
    size_t block_size;
    char filename[FILENAME_MAX];

    void *p; /* pointer to data_track or audio_track */
} track_infomation;

typedef struct {
    int index;

    track_infomation *ti;

    int compress;
    size_t offset;

    int mode;
	int iso_xa;

    LBN position;
} data_track;

typedef struct {
    int index;

    track_infomation *ti;

    size_t byte;
} audio_track;

typedef struct {
    int num;
    data_track *current;
    
    data_track dt[TRACK_MAX];
} data_track_list;

typedef struct {
    int num;
    audio_track *current;

    audio_track at[TRACK_MAX];
} audio_track_list;
    
typedef struct {
	char desc[DESC_MAX];

	int num_of_track;

	MSF total;

    track_infomation ti[TRACK_MAX];
} cd_infomation;

typedef struct {
	char *path;    /* FCD file path      */
	FILE *stream;  /* FCD file stream    */
	size_t pos;    /* stream position    */

	int type;      /* 0x00000001 ISO (MODE1)
	                  0x00000002 XA  (MODE2)
	                  0x00000004 DA
	                  0x00000000 Unknown */

	cd_infomation cdi;
	data_track_list dtl;
    audio_track_list atl;
} FCD;

typedef struct {
	char *data;
	size_t block_size;
	LBN num_of_block;
    int mode; /* 1 or 2, used by 2352 <-> 2XXX conversion */
} cd_image_buffer;

typedef struct {
	int num_of_unit;
	size_t *offsets;
} OFFSET_TABLE;

#ifndef FCD_C
extern int open_fcd_file(char *in, FCD *out);
extern int read_fcd_info(FILE *in, FCD *out);
extern int close_fcd_file(FCD *fcd);
extern int read_fcd_first_blocks(FCD *in, cd_image_buffer *out);
extern int read_fcd_data(FCD *in, cd_image_buffer *out);
extern int go_next_track(FCD *in);
extern int write_fcd_info(FCD *in, FILE *out);
extern int write_fcd_data(cd_image_buffer *in, FCD *out);
extern int init_fcd(FCD *fcd);
extern int add_track(FCD *fcd, char *filename);
extern int del_track(FCD *fcd, int track);
extern int move_track(FCD *fcd, int track, int down);
extern int sort_track_by_name(FCD *fcd);
extern int get_offset_table(FCD *in, OFFSET_TABLE *out);
#endif

#ifdef  __cplusplus
}
#endif

#endif
